# -*- coding: utf-8 -*-
"""
Created on Tue Apr 13 08:54:25 2021

@author: s168562

Script to analyze and plot the Holst straining data (electromechanical analysis).
"""
### Prerequisites
import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
from collections import OrderedDict
import os # for file paths
from math import ceil
import csv
# import sys
# sys.path.append(os.getcwd())
os.chdir(r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Analysis")
from cyclic_functions import read_data, calc_cycles
#import ggplot

### Enter file details
headerline = 225
filepath = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Raw\2022-04-25 LH-PU20 serpentines" # r to escape the backslashes
filename = "LH-PU20_EU94_meander_cut_12-10_2022-04-25_14.25.46#M01.txt"
nr_cycles = 50
max_strain = 1 # maximum strain ratio used (percentage = max_strain*100)
min_strain = 0 # min strain used.
outpath = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Analysis\Quickscan\Figures"
remove_first_point = False # Set to True to remove the first data point from the averaged data. (== R0)

### Read data
# outpathfull, straining_df, Rini, sampleID, mat, length, width, linewidth = read_data(
#     filename, filepath, headerline, outpath, nr_cycles, max_strain, 
#               min_strain);
(straining_df, Rini, sampleID, mat, length, width, linewidth, outpathfull) = read_data(
    filename, filepath, headerline, outpath, nr_cycles, max_strain, 
              min_strain);
# straining_df['Strain'] = straining_df['Position']/length
# (straining_df, strain_series_max, strain_series_max2, strain_series_min, 
#  strain_series_min2) = calc_cycles(straining_df, nr_cycles, length, max_strain, min_strain, Rini,
#                 remove_first_point)    

min_strain = [0, 0.008, 0.01, 0.012, 0.014, 0.016, 0.018, 0.02, 0.022, 0.024,
              0.026, 0.029, 0.031, 0.033, 0.036, 0.038, 0.041, 0.043, 0.046,
              0.049, 0.052, 0.055, 0.058, 0.061, 0.064, 0.067, 0.071, 0.073,
              0.076, 0.081, 0.084, 0.087, 0.091, 0.095, 0.099, 0.104, 0.107,
              0.111, 0.117, 0.119, 0.124, 0.129, 0.133, 0.138, 0.144, 0.148,
              0.153, 0.159, 0.164, 0.168]
max_strain = np.linspace(0.02, 1, 50)

straining_df['Strain'] = straining_df['Position']/length 
min_cycles_done = np.linspace(0, 49, 50)
max_cycles_done= np.linspace(0.40, 49.40, 50)

straining_df['Min_pos'] = False # Start of cycle (last point valley)
straining_df['Max_pos'] = False # start of top plateau 
cycle = 0

# somehow missing 2 values in the min range, but this should be the correct method.
# Pragmatically, I found an alternative method (see below)
for i in range(1,len(straining_df)):
    if cycle < 50:
        if (round(straining_df['Cycles_done'].iloc[i-1], 2) < min_cycles_done[cycle]):
            if round(straining_df['Cycles_done'].iloc[i],2) == min_cycles_done[cycle]:
                straining_df['Min_pos'][i] = True
                # print(cycle)
                # print(i)
        elif (round(straining_df['Cycles_done'].iloc[i-1], 2) < max_cycles_done[cycle]):
            if round(straining_df['Cycles_done'].iloc[i], 2) == max_cycles_done[cycle]:
                straining_df['Max_pos'][i] = True
                # print(cycle)
                # print(i)
                cycle += 1
        
# Check correctness by checking the number of positions captured
print(sum(straining_df['Min_pos']))
print(sum(straining_df['Max_pos']))

# Save the relevant data points at 0/1/19/20 % strain for calculations
# Normalize them by Rini
strain_series_max = straining_df['Resist_A'][straining_df['Max_pos']]
strain_series_min = straining_df['Resist_A'][straining_df['Min_pos']]

# Save the minimum R value before cycle 1 to use for normalization
Rmin1 = strain_series_min.values[0]

### Plots
## Plot prerequisites
# straining_df['Labels'] = straining_df['Cycle_nr'].values
# straining_df['Labels'] = straining_df['Labels'].astype(str)
plt.style.use('default') # default, ggplot, seaborn-*, dark_background, fivethirtyeight
plt.rcParams['font.size'] = 8 # set plot font size matplotlib
cm = 1/2.54  # convert centimeters to inches
### Default sans-serif fonts:
# plt.rcParams['font.sans-serif'] = ['DejaVu Sans',
#  'Bitstream Vera Sans',
#  'Computer Modern Sans Serif',
#  'Lucida Grande',
#  'Verdana',
#  'Geneva',
#  'Lucid',
#  'Arial',
#  'Helvetica',
#  'Avant Garde',
#  'sans-serif']
plt.rcParams['font.sans-serif'] = ['sans-serif',
                                   'sans-serif',
                                   'DejaVu Sans',
 'Bitstream Vera Sans',
 'Computer Modern Sans Serif',
 'Lucida Grande',
 'Verdana',
 'Geneva',
 'Lucid',
 'Arial',
 'Helvetica',
 'Avant Garde']

#plt.style.available()
# The palette with gray (fav: idx 2, 3)
cbPalVivid = ["#999999", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7"]

# The palette with black:
cbbPalette = ["#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7"]

cbPalblue = ["#f0f9e8", "#bae4bc", "#7bccc4", "#43a2ca","#0868ac"]
cbPalblueyellow = ["#ffffcc", "#a1dab4", "#41b6c4", "#2c7fb8","#253494"]
cbPalVivid_correctorder = ["#999999", "#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC"]
cbPalVivid = ["#999999", "#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75"]

# matplotlibs colormaps
# See https://matplotlib.org/stable/tutorials/colors/colormaps.html
cmaps = OrderedDict()
cmaps['Perceptually Uniform Sequential'] = [
            'viridis', 'plasma', 'inferno', 'magma', 'cividis']

# I like GnBu, BuGn
cmaps['Sequential'] = [
            'Greys', 'Purples', 'Blues', 'Greens', 'Oranges', 'Reds',
            'YlOrBr', 'YlOrRd', 'OrRd', 'PuRd', 'RdPu', 'BuPu',
            'GnBu', 'PuBu', 'YlGnBu', 'PuBuGn', 'BuGn', 'YlGn']



# Set font to Latex
# from matplotlib import rc
# rc('font', **{'family':'serif','serif':['Palatino']})
# rc('text', usetex=True)

#### Plot resistance over time
# width = 7*16/9, length = 7 in inches
plt.figure(figsize= [8*cm, 5.5*cm])
plt.plot(straining_df['Time'], straining_df['Resist_A']/1000, label = r'$R$',
         color = cbPalVivid[3], linewidth = 2)
ax = plt.axes()
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
plt.hlines(y = Rini/1000, xmin = min(straining_df['Time']), label = r'$R_0$',
            xmax = max(straining_df['Time']), linestyle = 'dashed',
            colors = cbPalVivid[4], linewidth = 2)
ax.set_facecolor("white")
plt.xlabel(r'Time [s]')
plt.ylabel(r'Resistance [k$\Omega$]')
figurepath_tiff = os.path.join(outpathfull, "RvsCycles.tiff")
figurepath_pdf = os.path.join(outpathfull, "RvsCycles.pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()


#### Plot normalized resistance over time
# width = 7*16/9, length = 7 in inches
plt.figure(figsize= [8*cm, 5.5*cm])
plt.plot(straining_df['Time'], straining_df['Resist_A']/Rmin1,
         color = cbPalVivid[3], linewidth = 2)
ax = plt.axes()
ax.set_ylim([0, 250])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
plt.xlabel(r'Time [s]')
plt.ylabel(r'$R/R_0$')
figurepath_tiff = os.path.join(outpathfull, "RvsCycles_norm.tiff")
figurepath_pdf = os.path.join(outpathfull, "RvsCycles_norm.pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

# strain on second axis
plt.figure(figsize= [8*cm, 5.5*cm])
fig,ax = plt.subplots(figsize= [8*cm, 5.5*cm])
lns1 = ax.plot(straining_df['Time'], straining_df['Resist_A']/Rmin1,
          color = cbPalVivid[3], linewidth = 2, label = 'Resistance', zorder = 2)
ax.tick_params(axis="x",direction="in", left="off", top="on")
ax.tick_params(axis="y",direction="in")
ax.set_facecolor("white")
ax.set_xlabel(r'Time [s]')
ax.set_ylabel(r'$R/R_0$')
ax.set_ylim([0, 250])
# second axis
ax2 = ax.twinx()
lns2 = ax2.plot(straining_df['Time'], 
          100*straining_df['Strain'],
          color = cbPalVivid[0], linewidth = 2, linestyle = 'dashed', 
          label = 'Strain', alpha = 0.6, zorder = 1)
ax2.set_ylabel(r'Strain [%]')
ax2.tick_params(axis="y",direction="in")
lns = lns1+lns2
labs = [l.get_label() for l in lns]
ax.legend(lns, labs, loc='lower center', borderaxespad=1, 
          ncol = 2, bbox_to_anchor = (0.5, -0.35), fontsize = 'small', 
          frameon = False)
figurepath_pdf = os.path.join(outpathfull, "R_strain.pdf")
figurepath_tiff = os.path.join(outpathfull, "R_strain.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

# strain on second axis - different ylim
plt.figure(figsize= [8*cm, 5.5*cm])
fig,ax = plt.subplots(figsize= [8*cm, 5.5*cm])
lns1 = ax.plot(straining_df['Time'], straining_df['Resist_A']/Rmin1,
         color = cbPalVivid[3], linewidth = 2, label = 'Resistance')
ax.tick_params(axis="x",direction="in", left="off", top="on")
ax.tick_params(axis="y",direction="in")
ax.set_facecolor("white")
ax.set_xlabel(r'Time [s]')
ax.set_ylabel(r'$R/R_0$')
ax.set_ylim([0.9, 3])
# second axis
ax2 = ax.twinx()
lns2 = ax2.plot(straining_df['Time'], 
         100*straining_df['Strain'],
         color = cbPalVivid[0], linewidth = 2, linestyle = 'dashed', 
         label = 'Strain', alpha = 0.6)
ax2.set_ylabel(r'Strain [%]')
ax2.tick_params(axis="y",direction="in")
# plt.grid()
lns = lns1+lns2
labs = [l.get_label() for l in lns]
ax.legend(lns, labs, loc='lower center', borderaxespad=1, 
          ncol = 2, bbox_to_anchor = (0.5, -0.35), fontsize = 'small',
          frameon = False)
figurepath_tiff = os.path.join(outpathfull, "R_strain_y1-3.tiff")
figurepath_pdf = os.path.join(outpathfull, "R_strain_y1-3.pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()


# strain on second axis - salmon - smaller figure for larger fonts
plt.figure(figsize= [5.5*cm, 3.8*cm])
fig,ax = plt.subplots(figsize= [5.5*cm, 3.8*cm])
lns1 = ax.plot(straining_df['Time'], straining_df['Resist_A']/Rmin1,
         color = cbPalVivid[2], linewidth = 1.5, label = 'Resistance')
ax.tick_params(axis="x",direction="in", left="off", top="on")
ax.tick_params(axis="y",direction="in")
ax.set_facecolor("white")
ax.set_xlabel(r'Time [s]')
ax.set_ylabel(r'$R/R_0$')
ax.set_ylim([0, 250])
# second axis
ax2 = ax.twinx()
lns2 = ax2.plot(straining_df['Time'], 
         100*straining_df['Strain'],
         color = cbPalVivid[0], linewidth = 1.5, linestyle = 'dashed', 
         label = 'Strain', alpha = 0.6)
ax2.set_ylabel(r'Strain  [%]')
ax2.tick_params(axis="y",direction="in")
lns = lns1+lns2
labs = [l.get_label() for l in lns]
ax.legend(lns, labs, loc='lower center', borderaxespad=1, 
          ncol = 2, bbox_to_anchor = (0.5, -0.5), fontsize = 'small',
          frameon = False)
figurepath_tiff = os.path.join(outpathfull, "R_strain_salmon_smaller_axis.tiff")
figurepath_pdf = os.path.join(outpathfull, "R_strain_salmon_smaller_axis..pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

# strain on second axis - blue - smaller figure for larger fonts
plt.figure(figsize= [5.5*cm, 3.8*cm])
fig,ax = plt.subplots(figsize= [5.5*cm, 3.8*cm])
lns1 = ax.plot(straining_df['Time'], straining_df['Resist_A']/Rmin1,
         color = cbPalVivid[3], linewidth = 1.5, label = 'Resistance')
ax.tick_params(axis="x",direction="in", left="off", top="on")
ax.tick_params(axis="y",direction="in")
ax.set_facecolor("white")
ax.set_xlabel(r'Time [s]')
ax.set_ylabel(r'$R/R_0$')
ax.set_ylim([0, 250])
# second axis
ax2 = ax.twinx()
lns2 = ax2.plot(straining_df['Time'], 
         100*straining_df['Strain'],
         color = cbPalVivid[0], linewidth = 1.5, linestyle = 'dashed', 
         label = 'Strain', alpha = 0.6)
ax2.set_ylabel(r'Strain  [%]')
ax2.tick_params(axis="y",direction="in")
lns = lns1+lns2
labs = [l.get_label() for l in lns]
ax.legend(lns, labs, loc='lower center', borderaxespad=1, 
          ncol = 2, bbox_to_anchor = (0.5, -0.5), fontsize = 'small',
          frameon = False)
figurepath_tiff = os.path.join(outpathfull, "R_strain_smaller_axis.tiff")
figurepath_pdf = os.path.join(outpathfull, "R_strain_smaller_axis..pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()



### Gauge factor calculations
# DGF0 = (strain_series_max.values[0] - Rini)/(Rini*max_strain[0]) # initial gauge factor
# GF0 = (strain_series_max.values[0] - Rini)/(Rini*max_strain[0]) # initial gauge factor

header = ['GF1_R0']
data_DGF = ['DGF_maxstrain'] #[DGF0]
data_GF = ['GF'] #[GF0]
for i in range(50):
    DGF = (strain_series_max.values[i] - strain_series_min.values[i])/(strain_series_min.values[i]*max_strain[i])
    GF = (strain_series_max.values[i] - Rini)/(Rini*max_strain[i])
    GFname = 'GF_' + str(round(max_strain[i]*100))
    header.append(GFname)
    data_DGF.append(DGF)
    data_GF.append(GF)

#Write gauge factor data to csv file
csvpath = os.path.join(outpathfull, "gaugefactors.csv")
with open(csvpath, 'w', newline='') as f:
    writer = csv.writer(f)
    writer.writerow(header)
    writer.writerow(data_DGF)
    writer.writerow(data_GF)